/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.block.tile.TileFakeAir;

public class SubTileBubbell
extends TileEntityFunctionalFlower {
    private static final int RANGE = 12;
    private static final int RANGE_MINI = 6;
    private static final int COST_PER_TICK = 4;
    private static final String TAG_RANGE = "range";
    int range = 2;

    protected SubTileBubbell(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public SubTileBubbell(BlockPos pos, BlockState state) {
        this(ModSubtiles.BUBBELL, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.m_58904_().f_46443_) {
            return;
        }
        if (this.ticksExisted % 200 == 0) {
            this.sync();
        }
        if (this.getMana() > 4) {
            this.addMana(-4);
            if (this.ticksExisted % 10 == 0 && this.range < this.getRange()) {
                ++this.range;
            }
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)this.getEffectivePos().m_142082_(-this.range, -this.range, -this.range), (BlockPos)this.getEffectivePos().m_142082_(this.range, this.range, this.range))) {
                BlockState state;
                if (!(this.getEffectivePos().m_123331_((Vec3i)pos) < (double)(this.range * this.range)) || (state = this.m_58904_().m_8055_(pos)).m_60767_() != Material.f_76305_) continue;
                this.m_58904_().m_7731_(pos, ModBlocks.fakeAir.m_49966_(), 2);
                TileFakeAir air = (TileFakeAir)this.m_58904_().m_7702_(pos);
                air.setFlower(this);
            }
        }
    }

    public static boolean isValidBubbell(Level world, BlockPos pos) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof SubTileBubbell) {
            SubTileBubbell bubbell = (SubTileBubbell)tile;
            return bubbell.getMana() > 4;
        }
        return false;
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_(TAG_RANGE, this.range);
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.range = cmp.m_128451_(TAG_RANGE);
    }

    @Override
    public int getMaxMana() {
        return 2000;
    }

    @Override
    public int getColor() {
        return 905097;
    }

    public int getRange() {
        return 12;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Circle(this.getEffectivePos(), this.range);
    }

    public static class Mini
    extends SubTileBubbell {
        public Mini(BlockPos pos, BlockState state) {
            super(ModSubtiles.BUBBELL_CHIBI, pos, state);
        }

        @Override
        public int getRange() {
            return 6;
        }
    }
}

